<?php
/**
 * This class is for sneeit article query to display items
 */
class Sneeit_Singular {
	var $ID = 0;
	var $title = '';
	var $title_attr = '';
	var $href = '';
	var $args = array(); /* reserve */
	var $au_ID = 0;
	var $au_name = '';
	var $au_href = '';
	var $comments_number = 0;
	var $comments_href = '';
	var $article_image = 'data:image/gif;base64,';
	var $article_image_width = 1000;
	var $artcile_image_height = 100;
	var $feature_media = '';	
	
	/**
	 * Every key which has _meta_ will default for get_post_meta
	 * Every key which has _mod_ will default for get_theme_mod
	 */
	function __construct($args = array()) {
		$this->ID = get_the_ID();			
		$this->args = wp_parse_args($args, $this->args);
		$this->title = balanceTags(get_the_title(), true);
		$this->title_attr = esc_attr($this->title);
		$this->href = esc_url(get_the_permalink());	
		
		$this->au_ID = get_the_author_meta('ID');
		$this->au_name = get_the_author_meta( 'display_name' );
		$this->au_href = esc_url(get_author_posts_url($this->au_ID));
		
		$this->comments_number = get_comments_number();
		$this->comments_href = $this->href . '#comments';
		
		// find feature image
	}	
	
	
	/**
	 * display start tag of article, <article>
	 */
	function start_tag($args = array()) {
		if (is_string($args)) {
			$args = array(
				'class' => $args
			);
		}
		$args = wp_parse_args($args, array(
			/* we will post meta of this key to get review data of post
			 * to check and then we can add micro data and open graph
			 * default: post-review
			 * the stored value must be generated by sneeit_review_system action
			 */
			'post_review_meta_key' => SNEEIT_KEY_POST_REVIEW, 
			'class' => ''
		));		
		
		$review = get_post_meta($this->ID, $args['post_review_meta_key'], true);
		$is_review = (
			is_array($review) && 
			!empty($review['type']) && 
			is_array($review[$review['type']] ) 
		);
		
		
		?><article <?php post_class($args['class']) ?> itemscope="itemscope" itemtype="https://schema.org/<?php echo ($is_review? 'Review' : 'NewsArticle'); ?>"><?php
	}
		
	
	/**
	 * We add disable_breadcrumb field to allow 
	 * developers control from their theme options
	 * you can control from disable_breadcrumb_mod_key args
	 */
	function crumbs($args = array()) {
		if (is_string($args)) {
			$args = array(
				'home_text' => $args
			);
		}
		$args = wp_parse_args($args, array(
			'before' => '<div class="crumbs">',
			'after' => '</div>',
			'home_text' => esc_html('Home', 'sneeit'), 
			
			/* We will get theme mod of this key
			 * to check if crumbs was disabled or not
			 * default: article-breadcrumb
			 */
			'article_breadcrumb_mod_key' => SNEEIT_KEY_ARTICLE_BREADCRUMB, 
		));
		
		if (get_theme_mod($args['article_breadcrumb_mod_key'], true)) {
			sneeit_utilities_breadcrumbs($args);
		}
	}

	/**
	 * get article image for open graph / meta / micro data
	 */	
	function article_image() {
		if (!empty($this->article_image) &&
			!empty($this->article_image_width) &&
			!empty($this->article_image_height)) {			
			return;
		}
		
		// DEFINE
		$image_html = '';
		$src = '';			

		// IF HAVE THUMBNAIL
		if (has_post_thumbnail( $this->ID ) ) {
			$img_id = get_post_thumbnail_id();			
			$img = wp_get_attachment_image_src($img_id, 'full');
			if (is_array($img) && 
				count($img) > 3 &&
				is_string($img[0]) &&
				is_numeric($img[1]) &&
				is_numeric($img[2])) {
				$this->article_image = $img[0];
				$this->article_image_width = $img[1];
				$this->article_image_height = $img[2];
				return;
			}			
		}

		// CHECK IF HAVE FEATURE MEDIA FIELD
		// scan in 		
		if (!empty($this->feature_media)) {		
			$src = sneeit_get_youtube_image($this->feature_media);
			if ($src) {
				$this->article_image = $src;
				$this->article_image_width = 320;
				$this->article_image_height = 180;
				return;
			}
			$src = sneeit_get_vimeo_image($this->feature_media);
			if ($src) {
				$this->article_image = $src;
				$this->article_image_width = 640;
				$this->article_image_height = 360;
				return;
			}			
		}
		
		// so, now, we must scan the first image			
		$src = sneeit_article_get_image_src(get_the_content());
			
		// found an attachment id
		if (is_numeric($src)) {							
			$img = wp_get_attachment_image_src($src, 'full');
			if (is_array($img) && 
				count($img) > 3 &&
				is_string($img[0]) &&
				is_numeric($img[1]) &&
				is_numeric($img[2])) {
				$this->article_image = $img[0];
				$this->article_image_width = $img[1];
				$this->article_image_height = $img[2];
				return;
			}
		}
		
		// found image, just output the image link
		if ( $src ) {
			$this->article_image = esc_url( $src );
			if (strpos($src, 'youtube') != 'false') {
				$this->article_image_width = 320;
				$this->article_image_height = 180;
			} else if (strpos($src, 'vimeo') != 'false') {
				$this->article_image_width = 640;
				$this->article_image_height = 360;
			}
		}
	}
	
	
	/**
	 * we will prority showing extra feature media first
	 * then post thumbnail if have
	 *
	 * you will place this function at all places you want to show feature box
	 * for each place, you will need to input the position name, 
	 * ex: above-title or under-title or whatever
	 * but only the place with name matched the article_feature_mod_key value will show
	 */
	function feature($args = array()) {
		if (is_string($args)) {
			$args = array(
				'position' => $args
			);
		}
		
		$args = wp_parse_args($args, array(
			/* you may not want to echo, but only get the part you want
			 * caption: get only the caption content
			 * src: get only feature image src (include thumbnail from youtube / vimeo)
			 * player: get only embeded iframe player if youtube or vimeo
			 */
			'return_data' => 'echo',
			
			'before' => '<div class="entry-feature-box">',
			'after' => '</div>',
			'before_media' => '<div class="entry-feature-box-media">',
			'after_media' => '</div>',
			'before_caption' => '<div class="entry-feature-box-caption">',
			'after_caption' => '</div>',			
			
			/* before and after. other value means hide */
			'caption_position' => 'after',
						
			/* we will use those keys to scan extra feature content 
			 * so you need to save your extra feature media in there
			 * ex: video links / embeded code
			 */
			/* - the theme mod to indicate position of feature box. 
			 * - default: article-feature */
			'article_feature_mod_key' => SNEEIT_KEY_ARTICLE_FEATURE,
			
			/* - the post meta contains the extra feature media content
			 * - default: post-feature-media */
			'post_feature_media_meta_key' => SNEEIT_KEY_POST_FEATURE_MEDIA,
			
			/* - the post meta contains feature box caption content 
			 * - default: post-feature-caption
			 */
			'post_feature_caption_meta_key' => SNEEIT_KEY_POST_FEATURE_CAPTION,			
						
			/* the value will be used to compare with 
			 * value of article_feature_mod_key theme mod to 
			 * check if we need to show or not for this position
			 * 
			 * if position is empty, always show
			 */
			'position' => 'above-title',
		));
				
		if ('echo' == $args['return_data'] && 
			!empty($args['position']) && 
			get_theme_mod($args['article_feature_mod_key'], 'above-title') != $args['position']) {
			return;	
		}
		
		$feature_media = get_post_meta($this->ID, $args['post_feature_media_meta_key'], true);
		$feature_caption = get_post_meta( $this->ID, $args['post_feature_caption_meta_key'], true );
		
		if ('caption' == $args['return_data']) {
			return $feature_caption;
		} else if ('src' == $args['return_data']) {
			$src = '';
			if (has_post_thumbnail( $this->ID )) {				
				$img_id = get_post_thumbnail_id();			
				$img = wp_get_attachment_image_src($img_id, 'full');
				if (is_array($img) && 
					count($img) > 3 &&
					is_string($img[0]) &&
					is_numeric($img[1]) &&
					is_numeric($img[2])) {
					$this->article_image = $img[0];
					$this->article_image_width = $img[1];
					$this->article_image_height = $img[2];
					$src = $img[0];
				}							
			}
			
			if (!$src &&  $feature_media) {
				$src = sneeit_get_youtube_image($feature_media);
				if (!$src) {
					$src = sneeit_get_vimeo_image($feature_media);
				}
			}

			return $src;
		} else if ('player' == $args['return_data']) {		
			$player = '';
			if ($feature_media) {				
				if ( strpos( $feature_media, 'vimeo' ) !== false ) {
					$player = sneeit_get_get_vimeo_player( $feature_media );
				} else if ( strpos( $feature_media, 'youtube' ) !== false || 
					strpos( $feature_media, 'youtu.be' ) !== false ) {
					$player = sneeit_get_youtube_player( $feature_media );
				}				
			}
			
			return $player;
		}

		if ($feature_media) {
			// save to display
			$this->feature_media = $feature_media;
			
			// if feature video url is actually video embedded HTML code
			if ( strpos( $feature_media, '<' ) !== false && strpos( $feature_media, '>' ) !== false ) {
				// do some thing here to process embedded code if need
			}
			// only vimeo url
			else if ( strpos( $feature_media, 'vimeo' ) !== false ) {
				$feature_media = sneeit_get_get_vimeo_player( $feature_media );
			} 
			// only youtube url
			else if ( strpos( $feature_media, 'youtube' ) !== false || strpos( $feature_media, 'youtu.be' ) !== false ) {
				$feature_media = sneeit_get_youtube_player( $feature_media );
			}
			// just invalid url
			else {
				$feature_media = '';
			}
		}

		if ($feature_media || has_post_thumbnail()) :
			echo $args['before'];
			echo $args['before_media'];
			if ($args['caption_position'] == 'before' && $feature_caption) {
				echo $args['before_caption'];
				echo $feature_caption;
				echo $args['after_caption'];
			}
			if ( $feature_media ) {
				echo $feature_media;
			}
			else {
				the_post_thumbnail( 'full', array(
					'alt' => $this->title_attr, 
					'title' => $this->title_attr,
				) );
			}
			echo $args['after_media'];
			if ($args['caption_position'] == 'after' && $feature_caption) {
				echo $args['before_caption'];
				echo $feature_caption;
				echo $args['after_caption'];
			}
			echo $args['after'];
		endif;
	}
	
	/**
	 * display title of the article
	 */
	function title() {
		echo '<h1 class="entry-title post-title" itemprop="name headline">'.$this->title.'</h1>';
	}
	
	/**
	 * display sub title if have
	 * the key is the post meta key which contains sub-title text
	 */
	function sub_title($key = 'sub-title') {
		$sub_title = get_post_meta($this->ID, $key, true);
		if ($sub_title) {
			$sub_title = balanceTags($sub_title, true);
			echo '<h2 class="entry-sub-title">'.$sub_title.'</h2>';
		}
	}
	
	/**
	 * display excerpt
	 */
	public function excerpt($args = array(), $echo = true) {
		$args = wp_parse_args($args, array(
			/* we will get theme mod of this key to check if
			 * user allow to display excerpt or not
			 * default: article-excerpt
			 */
			'article_excerpt_mod_key' => SNEEIT_KEY_ARTICLE_EXCERPT
		));
		/* check from excerpt first */
		$excerpt = '';
		if (has_excerpt() && get_theme_mod($args['article_excerpt_mod_key'], true)) {
			$excerpt = get_the_excerpt();
			if ($echo) {
				echo '<p class="entry-excerpt">'.$excerpt.'</p>';
			} else {
				return $excerpt;
			}
		}
		return $excerpt;
	}
	
	/**
	 * show some basic sharing buttons (without style)
	 * 
	 * you will call this function at all places you want to
	 * show share buttons, but only place which has value from
	 * article_sharing_position_mod_key equal with position args will
	 * be shown
	 * */
	public function sharing_buttons($args = array()) {
		if (is_string($args)) {
			if (strpos($args, ',')) {
				$networks = $args;
				$args = array();
				$args['networks'] = $networks;
			} else {
				$position = $args;			
				$args = array();
				$args['position'] = $position;
			}
		}
		
		$args = wp_parse_args($args, array(
			'before' => '<div class="entry-sharing-buttons">',
			'after' => '</div>',
			'link_class' => '',
			
			/* network can be array:
			 * key (network name) => value (text to display for button)
			 * 
			 * if network is string like: facebook, twitter
			 * it will be splitted by "," and key will be the value, 
			 * when text will be fontawesome icon
			 */
			
			/* the theme mod key which is storing 
			 * position setting for sharing buttons
			 * default: article-sharing-position
			 */
			'article_sharing_position_mod_key' => SNEEIT_KEY_ARTICLE_SHARING_POSITION,
			
			/* the theme mod key which is storing
			 * which network buttons will be shown
			 * default: article-sharing-buttons
			 * value will be an array of network names
			 * or a string of names separated by comma (,)
			 * ex: facebook,google
			 * 
			 * You can input $args['networks'] to display
			 * networks as you want regardless this value
			 */
			'article_sharing_buttons_mod_key' => SNEEIT_KEY_ARTICLE_SHARING_BUTTONS,
			
			/* We will use this to get custom code
			 * default: article-sharing-custom-code
			 */
			'article_sharing_custom_code_mod_key' => SNEEIT_KEY_ARTICLE_SHARING_CUSTOM_CODE,
			
			/* the value which will be used to compare with 
			 * article_sharing_position_mod_key value to decide
			 * if we need to show sharing buttons for this position
			 * or not
			 */
			'position' => 'bottom',
			
			/**
			 * @since 5.0
			 * show the name of network */
			'show_name' => false,
		));
			
		// check if the theme disable the sharing or not		
		$position = get_theme_mod($args['article_sharing_position_mod_key'], '');		
		if (!$position || 
			(	$position != $args['position'] && 
				strpos($position, '-'.$args['position']) === false ) 
			) {			
			return;
		}
		
		// check if we have custom sharing code
		// so we will priority show it
		$html = get_theme_mod($args['article_sharing_custom_code_mod_key'], '');
		if ($html) {
			echo $html = $args['before'].$html.$args['after'];
			return;
		}
		
		// now, collects networks
		if (empty($args['networks'])) {
			$args['networks'] = get_theme_mod($args['article_sharing_buttons_mod_key'], '');
			if (empty($args['networks'])) {				
				return;
			}
		}
		if (is_string($args['networks'])) {
			$args['networks'] = explode(',', $args['networks']);
		}
		
		$html = '';
		$title_urlencode = urlencode($this->title_attr);
		foreach ($args['networks'] as $key => $value) {
			$network = $value;
								
			// validate data
			if (is_array($value) || !is_numeric($key)) {
				$network = $key;
			}			
			
			$link = '';
			$link_text = '';
			switch (trim(strtolower($network))) {
				case 'facebook':
				case 'fb':
				case 'face':
					$network = 'facebook';
					$link = esc_url('https://www.facebook.com/sharer.php?u='.$this->href);
					$link_text = '<i class="fa fa-facebook"></i>';					
					break;
				
				case 'mail':
				case 'email':
				case 'e-mail':
					$network = 'e-mail';
					$link = esc_url('mailto:?subject='.$title_urlencode.'&body='.$this->href);
					$link_text = '<i class="fa fa-envelope-o"></i>';
					break;
				
				case 'twitter' :
				case 'tw' :
				case 'tweet' :
					$network = 'twitter';
					$link = esc_url('https://twitter.com/intent/tweet?text='.$title_urlencode.'&url='.$this->href);
					$link_text = '<i class="fa fa-twitter"></i>';
					break;
				
				case 'pin' :
				case 'pinterest' :
					$network = 'pinterest';
					$link = esc_url('https://pinterest.com/pin/create/bookmarklet/?url='.$this->href.'&title='.$title_urlencode);
					$link_text = '<i class="fa fa-pinterest-p"></i>';
					break;
				
				case 'whatsapp' :
					$network = 'whatsapp';
					$link = esc_url('https://wa.me/?text='. $title_urlencode . ' ' . $this->href);
					$link_text = '<i class="fa fa-whatsapp"></i>';
					break;
				
				case 'linkedin' :
				case 'linked' :
				case 'in' :
					$network = 'linkedin';
					$link = esc_url('https://www.linkedin.com/shareArticle?mini=true&url='.$this->href.'&title='.$title_urlencode);
					$link_text = '<i class="fa fa-linkedin"></i>';
					break;
				
				case 'skype':
					$network = 'skype';
					$link = esc_url('https://web.skype.com/share?url='.$this->href);
					$link_text = '<i class="fa fa-skype"></i>';
					break;
				
				case 'google-plus' :
				case 'g+' :
				case 'g-plus' :
				case 'gplus' :
				case 'google+' :
				case 'googleplus' :
					$network = 'google-plus';
					$link = esc_url('https://plus.google.com/share?url='.$this->href);
					$link_text = '<i class="fa fa-google-plus"></i>';
					break;
				
				default:
					break;
			}
			
			/**
			 * @since 5.0
			 * Show name of network if user want
			 */
			if (!empty($args['show_name'])) {
				$link_text .= '<span>' . ucfirst($network) . '</span>';
			}
			
			if ($link) {
				$before_link = '';
				$after_link = '';
				$before_text = '';
				$after_text = '';
				
				
				// get before / after link tag
				if (!empty($args['before_link'])) {
					$before_link = $args['before_link'];
				}
				if (!empty($value['before_link'])) {
					$before_link = $args['before_link'];
				}
				if (!empty($args['after_link'])) {
					$after_link = $args['after_link'];
				}
				if (!empty($value['after_link'])) {
					$after_link = $args['after_link'];
				}

				// get before / after text tag
				if (!empty($args['before_text'])) {
					$before_link = $args['before_text'];
				}
				if (!empty($value['before_text'])) {
					$before_link = $args['before_text'];
				}
				if (!empty($args['after_text'])) {
					$after_link = $args['after_text'];
				}
				if (!empty($value['after_text'])) {
					$after_link = $args['after_text'];
				}
				
				
				// link text data
				if (!is_numeric($key) && is_string($value)) {
					$link_text = $value['text'];
				} else if (is_array($value) && !empty ($value['text'])) {
					$link_text = $value['text'];				
				}
			}
			
			$target = 'target="_blank"';
			if (!empty($args['window']) || !isset($args['window'])) {
				$target = 'onclick="window.open(this.href, \'mywin\',\'left=50,top=50,width=600,height=350,toolbar=0\'); return false;"';
			}
			
			if ($args['link_class']) {
				$args['link_class'] .= ' ';
			}
			
			$html .= 
				$before_link .
					'<a href="'.$link.'" '.$target.' class="'.$args['link_class'].$network.'" title="'.esc_attr(ucfirst($network)).'">' . 
						$before_text . $link_text . $after_text .
					'</a>' .
				$after_link;			
		}
		
		if ($html) {
			$html = $args['before'].$html.$args['after'];			
		}
		
		echo $html;
	}
	
	/**
	 * show author name
	 */
	function author($args = array()) {
		$args = wp_parse_args($args, array(
			'before' => '', 
			'after' => '',
			'before_text' => '',
			'after_text' => '',
			'link_class' => 'entry-author hcard fn',
			'icon' => 'fa-user-circle-o',
			
			/* the theme mod key which contains value to 
			 * check if we need to display author name or not.
			 * default:  article-author 
			 * values: icon, avatar, name, or blank to hide
			 */
			'article_author_mod_key' => SNEEIT_KEY_ARTICLE_AUTHOR,
		));
		
		$show = get_theme_mod($args['article_author_mod_key'], true);
		if (!$show) {
			return '';
		}

		switch (trim(strtolower($show))) {
			case 'icon':
				$args['before_text'] .= (sneeit_font_awesome_tag($args['icon'])  . ' ');
				break;
			case 'avatar':
				$avatar = get_avatar($this->au_ID, 16, '', esc_attr($this->au_name));
				if (!empty($avatar)) {
					$args['before_text'] .= ($avatar . ' ');
				}		
				break;
			default:
				break;
		}

		echo $args['before'].'<a class="'.$args['link_class'].'" href="'.$this->au_href.'" target="_blank">'.$args['before_text'].$this->au_name.$args['after_text'].'</a>'.$args['after'];
	}
	
	/**
	 * show date time
	 */
	function date_time($args = array()) {
		$args = wp_parse_args($args, array(
			'before' => '', 
			'after' => '',
			'before_text' => '',
			'after_text' => '',
			'link_class' => 'entry-date updated',
			'ago_text' => esc_html__('%s ago', 'sneeit'),
			
			/* the theme mod key which contains value to
			 * check if wwe show date time or not
			 * default: article-date-time
			 * values: 
			 * PUBLISH DATE TIME
			 * 'full', 'date', 'time', 'short', 'pretty'
			 * 
			 * UPDATE DATE TIME
			 * 'updated-full', 'updated-date', 'updated-time', 'updated-short', 'updated-pretty'
			 * 'modified-full', 'modified-date', 'modified-time', 'modified-short', 'modified-pretty'
			 * 
			 * if value contains 'updated' or 'modified', 
			 * we will show the updated / modify instead of publish date
			 */
			'article_date_time_mod_key' => SNEEIT_KEY_ARTICLE_DATE_TIME
		));
		
		$show = get_theme_mod($args['article_date_time_mod_key'], true);
		if (!$show) {
			return '';
		}
		
		/* SHOW VALUES */		
		$source = '';
		if (strpos($show, '-') !== false) {
			$show = explode('-', $show);
			$source = $show[0];
			$show = $show[1];
		}
		
		$html = '';
		if ($source == 'updated' || $source == 'modified') {
			switch (trim(strtolower($show))) {
				case 'pretty':
					$html .= sprintf( $args['ago_text'], human_time_diff(get_the_modified_date( 'U' ), current_time( 'timestamp' ) ) );
					break;

				case 'short':
					if (get_option('date_format')) {
						$html .= get_the_modified_date(str_replace('F', 'M', get_option('date_format')));
					}
					break;

				case 'time':
					$html .= get_the_modified_time();
					break;

				case 'date':
					$html .= get_the_modified_date();
					break;

				default:
					$html .= get_the_modified_date().' '.get_the_modified_time();
					break;
			}			
		} else {
			switch ($show) {
				case 'pretty':
					$html .= sprintf( $args['ago_text'], human_time_diff( get_the_time( 'U' ), current_time( 'timestamp' ) ) );				
					break;

				case 'short':
					if (get_option('date_format')) {
						$html .= get_the_date(str_replace('F', 'M', get_option('date_format')));
					}
					break;

				case 'time':
					$html .= get_the_time();
					break;

				case 'date':
					$html .= get_the_date();
					break;

				default:
					$html .= get_the_date().' '.get_the_time();
					break;
			}
		}
		
		if ($html) {
			echo $args['before'].'<a class="'.$args['link_class'].'" href="'.$this->href.'">'.$args['before_text'].$html.$args['after_text'].'</a>'.$args['after'];
		}		
	}
	
	/**
	 * show comment number
	 */
	function comments_number($args = array()) {
		$args = wp_parse_args($args, array(
			'before' => '', 
			'after' => '',
			'before_text' => '<i class="fa fa-comment-o"></i> ',
			'after_text' => '',
			'link_class' => 'entry-comment-count',
			
			/* the theme mode key contains value to
			 * check if we need to show or not
			 * 
			 * default: article-comments-number
			 */
			'article_comments_number_mod_key' => SNEEIT_KEY_ARTICLE_COMMENTS_NUMBER
		));
		
		if (!get_theme_mod($args['article_comments_number_mod_key'], true) || !comments_open()) {
			return '';
		}
				
		echo $args['before'].'<a class="'.$args['link_class'].'" href="'.$this->comments_href.'">'.$args['before_text'].$this->comments_number.$args['after_text'].'</a>'.$args['after'];
	}
	
	/**
	 * display ads slots which have
	 * different ads between desktop and mobile
	 * 
	 * we will get code from theme mod $args['desktop_mod_key'] key
	 * to display ads for desktop
	 * and $args['mobile_mod_key'] for mobile
	 */
	function ads($args = array()) {
		if (is_string($args)) {
			$args = array(
				'id' => $args,
			);
		}
				
		
		if (empty($args['id'])) {	
			$args['id'] = 'article-ads';			
		}
		if (empty($args['desktop_mod_key'])) {
			$args['desktop_mod_key'] = $args['id'].'-desktop';
		}
		if (empty($args['mobile_mod_key'])) {
			$args['mobile_mod_key'] = $args['id'].'-mobile';
		}
		if (empty($args['before'])) {
			$args['before'] = '<div id="'.$args['id'].'" class="'.$args['id'].'">';
		}
		if (empty($args['after'])) {
			$args['after'] = '</div>';
		}
		
		if (wp_is_mobile()) {
			$ads = get_theme_mod($args['mobile_mod_key'], '');			
		} else {
			$ads = get_theme_mod($args['desktop_mod_key'], '');
		}
		
		if ($ads) {
			echo $args['before'].$ads.$args['after'];
		}
	}
	
	/**
	 * display category list
	 */
	function categories($args = array()) {
		$args = wp_parse_args($args, array(
			'before' => '', 
			'after' => '',
			'before_text' => '',
			'after_text' => '',
			'before_link' => '',
			'after_link' => '',
			'link_class' => 'entry-category',
			'show_count' => false,
			'before_count' => '',
			'after_count' => '',
			'separator' => '',
			
			/* the theme mod key contains value to
			 * check if we need to show or not
			 * 
			 * default: article-categories
			 */
			'article_categories_mod_key' => SNEEIT_KEY_ARTICLE_CATEGORIES
		));
		if (!get_theme_mod($args['article_categories_mod_key'], false)) {
			return;
		}
		$categories = get_the_category();	
		$html = '';
		if ($args['link_class']) {
			$args['link_class'] = ' class="'.$args['link_class'].'"';
		}
		foreach($categories as $category) {
			
			if ($html) {
				$html .= $args['separator'];
			}
			
			$html .= $args['before_link'];
			$html .= '<a'.$args['link_class'].' href="'.get_category_link( $category->term_id ).'" rel="tag">';
			$html .= $args['before_text'] . $category->name . $args['after_text'];
			
			if ($args['show_count']) {
				$html .= $args['before_count'].$category->count.$args['after_count'];
			}
			
			$html .= '</a>'.$args['after_link'];			
		}
		
		if ($html) {
			echo $args['before'] .$html. $args['after'];
		}
	}
	
	/**
	 * display tag list
	 */
	function tags($args = array()) {
		$args = wp_parse_args($args, array(
			'before' => '', 
			'after' => '',
			'before_text' => '',
			'after_text' => '',
			'before_link' => '',
			'after_link' => '',
			'link_class' => 'entry-category',
			'show_count' => false,
			'before_count' => '',
			'after_count' => '',
			'separator' => '',
			
			/* the theme mod key contains value to
			 * check if we need to show or not
			 * 
			 * default: article-tags
			 */
			'article_tags_mod_key' => SNEEIT_KEY_ARTICLE_TAGS
		));
		if (!get_theme_mod($args['article_tags_mod_key'], false)) {
			return;
		}
		$tags = get_the_tags();	
		if (empty($tags)) {
			return;
		}
		
		$html = '';
		if ($args['link_class']) {
			$args['link_class'] = ' class="'.$args['link_class'].'"';
		}
		foreach($tags as $tag) {
			if ($html) {
				$html .= $args['separator'];
			}
			
			$html .= $args['before_link'];
			$html .= '<a'.$args['link_class'].' href="'.  get_tag_link( $tag->term_id ).'" rel="tag">';
			$html .= $args['before_text'] . $tag->name . $args['after_text'];
			
			if ($args['show_count']) {
				$html .= $args['before_count'].$tag->count.$args['after_count'];
			}
			
			$html .= '</a>'.$args['after_link'];			
		}
		
		if ($html) {
			echo $args['before'] .$html. $args['after'];
		}
	}
	
	/**
	 * show author box
	 */
	function author_box($args = array()) {
		$args = wp_parse_args($args, array(
			'before' => '',
			'after' => '',			
			
			'avatar_size' => 32,
			'before_avatar' => '',
			'after_avatar' => '',
			'before_name' => '',
			'after_name' => '',	
			
			/* the theme mod key contains value to
			 * check if we need to show or not
			 * 
			 * default: article-author-box
			 */
			'article_author_box_mod_key' => SNEEIT_KEY_ARTICLE_AUTHOR_BOX,
			
			/* the user meta key contains value of
			 * social links which will be show in author box
			 * default: user-social-links
			 * value is a textarea value and will has one social link per line
			 */
			'user_social_links_key' => SNEEIT_KEY_USER_SOCIAL_LINKS,	
			
			/* use this to reorder elements of author box as you want
			 * html is allowed
			 * 
			 * Elements:
			 * [id] [name] [avatar] [link] [social] [bio]
			 */
			'template' => '', 
			
			/* social_args */
		));
		if (empty($args['template'])) {
			return;
		}
		if (!get_theme_mod($args['article_author_box_mod_key'], false)) {
			return;
		}
		
		$author_id = get_the_author_meta('ID');
		$author_link = get_author_posts_url($author_id);
		$author_name = get_the_author_meta( 'display_name' );
		
		// replace id
		if (strpos($args['template'], '[id]') !== false) {
			$args['template'] = str_replace('[id]', $author_id, $args['template']);
		}
		
		// replace name
		if (strpos($args['template'], '[name]') !== false) {
			$display_name = '<a href="'.$author_link.'" itemprop="url" rel="author"><span itemprop="name">'.$author_name.'</span></a>';
			$args['template'] = str_replace('[name]', $display_name, $args['template']);
		}
		
		// replace avatar
		if (strpos($args['template'], '[avatar]') !== false) {
			$args['template'] = str_replace('[avatar]', $args['before_avatar'].'<a href="'.$author_link.'">'.get_avatar($author_id, $args['avatar_size'], '', $author_name).'</a>'.$args['after_avatar'], $args['template']);
		}
		
		// replace social links
		if (strpos($args['template'], '[social]') !== false) {
			$social_args = array(
				'urls' => get_user_meta($author_id, $args['user_social_links_key'], true),
				'echo' => false,
			);
			if (!empty($args['social_args'])) {
				$social_args = wp_parse_args($social_args, $args['social_args']);
			}
			
			$args['template'] = str_replace('[social]', apply_filters('sneeit_social_links_to_fontawesome', $social_args), $args['template']);
		}
		
		// replace bio
		if (strpos($args['template'], '[bio]') !== false) {
			$args['template'] = str_replace('[bio]', '<span itemprop="description">'.get_the_author_meta('description',$author_id).'</span>', $args['template']);
		}
		
		// display code		
		echo $args['before'].'<div itemprop="author" itemscope="itemscope" itemtype="https://schema.org/Person">'.$args['template'].'</div>'.$args['after'];
	}
	
	/**
	 * show post next / prev link
	 */	
	function post_nextprev($args = array()) {
		
		$args = wp_parse_args($args, array(
			'before' => '',
			'after' => '',
			'before_link' => '',
			'after_link' => '',
			'before_next_link' => '',
			'after_next_link' => '',
			'before_prev_link' => '',
			'after_prev_link' => '',
			
			/* the theme mod key contains value to
			 * check if we need to show or not
			 * 
			 * default: article-nextprev
			 */
			'article_nextpev_mod_key' => SNEEIT_KEY_ARTICLE_NEXTPREV,		
		));
		
		if (!get_theme_mod($args['article_nextpev_mod_key'], true)) {
			return;
		}
		
		$has_next = get_adjacent_post(false, '', false);
		$has_prev = get_adjacent_post(false, '', true);
		
		if (!($has_next || $has_prev)) {
			return;
		}
		
		$html = $args['before'];
				
		if ($has_next) {
			$html .= $args['before_link'] . $args['before_next_link'];
			$html .= get_next_post_link('%link');
			$html .= $args['after_next_link'].$args['after_link'];
		}
		
		if ($has_prev) {
			$html .= $args['before_link'] . $args['before_prev_link'];
			$html .= get_previous_post_link('%link');
			$html .= $args['after_prev_link'].$args['after_link'];
		}
		
		$html .= $args['after'];
		
		echo $html;
	}	
	
	/**
	 * show post next / prev link for attachment pages
	 */
	function image_nextprev($args = array()) {		
		$args = wp_parse_args($args, array(
			'before' => '',
			'after' => '',
			'before_link' => '',
			'after_link' => '',
			'next_text' => false, 
			'prev_text' => false,
			'before_next_link' => '',
			'after_next_link' => '',
			'before_prev_link' => '',
			'after_prev_link' => '',	
		));
		$html = '';
		
		$next = '';
		ob_start();
		next_image_link( false, $args['next_text'] );
		$next = ob_get_clean();				
		if ($next) {
			$html .= $args['before_link'] . $args['before_next_link'] . $next . $args['after_next_link'] . $args['after_link'];
		}
		
		
		$prev = '';
		ob_start();
		previous_image_link( false, $args['prev_text'] );
		$prev = ob_get_clean();		
		if ($prev) {
			$html .= $args['before_link'] . $args['before_prev_link'] . $prev . $args['after_prev_link'] . $args['after_link'];
		}
		
		if ($html) {
			$html = $args['before'] . $html . $args['after'];
		}
				
		
		echo $html;
	}	
	
	
	/**
	 * END OF ARTICLE TAG </article>
	 */
	function end_tag($args = array()) {		
		$args = wp_parse_args($args, array(
			/* we will get this theme mode value to add schema 
			 * data about your organization
			 * 
			 * default: site-logo
			 * value must be an image src
			 */
			'site_logo_mod_key' => SNEEIT_KEY_SITE_LOGO,
		));
		
		/* article image */
		$this->article_image();
		?><span style="display:none" itemprop="image" itemscope itemtype="https://schema.org/ImageObject"><?php
			?><meta itemprop="url" content="<?php echo esc_attr($this->article_image); ?>"><?php
			?><meta itemprop="width" content="<?php echo esc_attr($this->article_image_width);  ?>"><?php
			?><meta itemprop="height" content="<?php echo esc_attr($this->article_image_height);  ?>"><?php
		?></span><?php
		
		/* date time */
		?><meta itemprop="datePublished" content="<?php echo esc_attr(get_the_date('c')); ?>"><?php
		?><meta itemprop="dateModified" content="<?php echo esc_attr(get_the_modified_date('c')); ?>"><?php
		
		/* publisher */
		?><span itemprop="publisher" itemscope itemtype="https://schema.org/Organization"><?php
							if (get_theme_mod('site_logo')) : 
?><span itemprop="logo" itemscope itemtype="https://schema.org/ImageObject"><meta itemprop="url" content="<?php echo esc_attr(get_theme_mod($args['site_logo_mod_key']));?>"></span><?php 
							endif; 
?><meta itemprop="name" content="<?php echo esc_attr(get_bloginfo( 'description')) ?>"></span><?php

		/* misc */
		?><meta itemscope itemprop="mainEntityOfPage" itemType="https://schema.org/WebPage" itemid="<?php 
			echo esc_attr(get_the_permalink()); 
		?>" content=""/><?php
				
		?></article><?php
	}
}

add_filter('sneeit_singular', 'sneeit_singular');
function sneeit_singular($args) {
	return (new Sneeit_Singular($args));
}